Frequency domain capacitance meter circuit
**********************************************************************
.AC  LIN  1000  1.0e-3  10.0e+9  SWEEP  Bias  LIN  3  0  5
.OPTIONS POST=1 POST_VERSION=9007 PROBE ACCURATE
+ INGOLD  CO=132  UNWRAP  NUMDGT=8 MEASDGT=8
.LIB 'Process.lib' Typ
**********************************************************************
.TEMP  25
.param Ampl= 1.0e-3
.param Bias= 0
.param pi =  3.1415926535897932384626433832795
**********************************************************************
.PARAM  Vin  = 0.0V
.PARAM  Ven  = 0.0V
**********************************************************************
.probe  AC
*
+ C_total    = PAR('abs(Ii(Vac))/(2*pi*HERTZ*Ampl)')
+ C_pullup   = PAR('abs(Ii(Vvcc))/(2*pi*HERTZ*Ampl)')
+ C_pulldown = PAR('abs(Ii(Vgnd))/(2*pi*HERTZ*Ampl)')
**********************************************************************
Vvcc  Vcc   0  DC= 5.0
Vgnd  GRND  0  DC= 0.0
Vin   In    0  DC= Vin
Ven   En    0  DC= Ven
Vac   Pad   0  AC= Ampl  DC= Bias
*
X1  In  Pad  Vcc  Vcc  GRND  GRND  En  IO_buf
*R1     Pad  GRND  R=30                 $ Test resistor (for driver ON)
*C1     Pad  GRND  C=10.0pF             $ Test capacitor
**********************************************************************
.alter
.PARAM  Vin = 5.0V
.PARAM  Ven = 0.0V
*
.alter
.PARAM  Vin = 0.0V
.PARAM  Ven = 5.0V
*
.alter
.PARAM  Vin = 5.0V
.PARAM  Ven = 5.0V
**********************************************************************
.END
**********************************************************************
